/* $OpenLDAP: pkg/ldap/servers/slapd/tools/slapcommon.h,v 1.13.2.2 2003/10/13 01:57:03 kurt Exp $ */
/*
 * Copyright 1998-2003 The OpenLDAP Foundation, All Rights Reserved.
 * COPYING RESTRICTIONS APPLY, see COPYRIGHT file
 */
/* slapcommon.h - common definitions for the slap tools */

#ifndef SLAPCOMMON_H_
#define SLAPCOMMON_H_ 1

#define SLAPD_TOOLS 1
#include "../slap.h"

enum slaptool {
	SLAPCAT=1,	/* database -> LDIF tool */
	SLAPADD,	/* LDIF -> database tool */
	SLAPINDEX,	/* database index tool */
	SLAPTEST	/* database testing tool */
};

#define SLAP_TOOL_CTXCSN_KEEP	0
#define SLAP_TOOL_CTXCSN_ENTRY	1
#define SLAP_TOOL_CTXCSN_BATCH	2

extern	char	*progname;
extern	char	*conffile;
extern	Backend *be;
extern	int		appendmode;
extern	int		verbose;
extern	int		update_ctxcsn;
extern	int		retrieve_ctxcsn;
extern	int		retrieve_synccookie;
extern	int		replica_promotion;
extern	int		replica_demotion;
extern	char    *replica_id_string;
extern	char    **replica_id_strlist;
extern	int     *replica_id_list;
extern	int		continuemode;
extern	int		nosubordinates;
extern	int		dryrun;
extern	struct berval	sub_ndn;

extern	char	*ldiffile;
extern	FILE	*ldiffp;

void slap_tool_init LDAP_P((
	const char* name,
	int tool,
	int argc, char **argv ));

void slap_tool_destroy LDAP_P((void));

#endif /* SLAPCOMMON_H_ */
